playerHeading = {

   -- Customize this value to adjust how fast the heading changes.
   locationCount = 5,
   -- Do not touch anything beyond this line

   lastInserted = nil,
   lastPositions = {n=locationCount},

   currentHeading = nil
}

function playerHeading.update ()

   local bcount, bsum, dist, bearing

   if playerHeading.lastInserted == nil then
      playerHeading.lastInserted = 1
      playerHeading.lastPositions[1] = Player.ObjectLocation
      return
   end

   dist, bearing = Wherigo.VectorToPoint(playerHeading.lastPositions[playerHeading.lastInserted],Player.ObjectLocation)

   if dist("m") < 1 then
      return
   end

   bcount = 0
   bsum = 0

   for k,v in ipairs(playerHeading.lastPositions) do
      dist, bearing = Wherigo.VectorToPoint(v, Player.ObjectLocation)
      bcount = bcount + 1
      bsum = bsum + bearing
   end

   playerHeading.currentHeading = bsum / bcount

   playerHeading.lastInserted = playerHeading.lastInserted + 1
   if playerHeading.lastInserted > playerHeading.locationCount then
      playerHeading.lastInserted = 1
   end
   playerHeading.lastPositions[playerHeading.lastInserted] = Player.ObjectLocation
end

function playerHeading.getHeading ()
   return playerHeading.currentHeading
end
